@extends('layouts.master')

@section('title')
تقرير  نهائي للدورة التدريبية {{$room->name}} برنامج {{$room->course->title}}
@endsection

@section('first-css')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/charts.css/dist/charts.min.css">

<link href="{{asset('/css/report.css')}}" rel="stylesheet">
@endsection

@section('content-body')
    <!--**********************************
                                Content body start
                            ***********************************-->
    @include('massages')
@section('route-path')
    <div class="container-fluid container-fluid-traning px-0">
        <div class="d-flex flex-wrap align-items-end justify-content-between  mb-3">
            <h3>
                تقرير  نهائي للدورة التدريبية {{$room->name}} برنامج {{$room->course->title}}
            </h3>
            <div class="link">
                <a href="" class="px-4 ">عرض تقرير  نهائي
                </a>
            </div>
        </div>
    </div>
@endsection 
<div class="d-flex flex-wrap align-items-start justify-content-start  mb-3 btns">
        <button  id="printCertificate"  type="button" class="btn btn-secondary  me-1"  >
            <i class="mdi mdi-print-circle ms-2"></i>طباعة
        </button>
    </div>
<!-- row -->
<div class="code-example">
    <style name="datasets-example-3">
        #datasets-example-3 {
            display: flex;
            flex-wrap: wrap;
            flex-direction: row-reverse;
            align-items: center;
            gap: 20px;
            /* max-width: 1200px; */
            margin: 0 auto;
        }

        #datasets-example-3 .column {

            height: 160px;
            max-width: 800px;
        }

        #datasets-example-3 .legend {
            flex-shrink: 3;
        }

        .charts-css.legend li:nth-child(1)::before {
            background: #8bdd7c;
        }

        .charts-css.legend li:nth-child(2)::before {
            background: #ffe583;
        }

        .charts-css.legend li:nth-child(3)::before {
            background: #ffc765;
        }

        .charts-css.legend li:nth-child(4)::before {
            background: #5f5e5e;
        }
    </style>

    <div id="datasets-example-3">
        @isset($evaluations)
            @foreach ($evaluations as $evaluation)
                @if ($evaluation->type == 0)
                    <h2 style="margin-top:10px; text-align: right; width:100%">{{ $evaluation->name }}</h2>
                    <table style="width: 100%"
                        class="charts-css column multiple show-labels data-spacing-1 datasets-spacing-1">

                        <tbody style="width:100%">

                            @foreach ($evaluation->values as $value)
                                <tr style="margin-right: 20px">
                                    <th scope="row" style="margin-bottom: -20px;"> {{ $value->name }} </th>
                                    <td
                                        style="--size:@if ($value->excellent == 0) 0.05 @else{{ $value->excellent / 100 }} @endif; --color: #8bdd7c;">
                                        <span class="data"> {{ round($value->excellent) }} % </span>
                                    </td>
                                    <td
                                        style="--size:@if ($value->very_good == 0) 0.05 @else{{ $value->very_good / 100 }} @endif;--color: #ffe583;">
                                        <span class="data"> {{ round($value->very_good) }} % </span>
                                    </td>
                                    <td
                                        style="--size:@if ($value->good == 0) 0.05 @else {{ $value->good / 100 }} @endif;--color:#ffc765;">
                                        <span class="data">{{ round($value->good) }} % </span>
                                    </td>
                                    <td
                                        style="--size:@if ($value->week == 0) 0.05 @else {{ $value->week / 100 }} @endif; --color:#5f5e5e;">
                                        <span class="data"> {{ round($value->week) }} % </span>
                                    </td>

                                </tr>
                            @endforeach
                            <ul class="charts-css legend legend-inline legend-square" >
                                <li> ممتاز </li>
                                <li> جيدجدا </li>
                                <li> جيد </li>
                                <li> مقبول </li>

                            </ul>
                        </tbody>
                    </table>
                @endif
            @endforeach
        @endisset
    </div>
</div>

 <h2 style="margin-top: 20px">الحضور والغياب</h2>
@include('reports.tabels.attendances-room')

<h2>الاختبارات</h2>
@include("reports.tabels.exam-room")
<h2>التقييمات</h2>
@include('reports.tabels.evaluation')


@endsection
@section('script')
<script src="{{asset('js/print/report.js')}}"></script>

@endsection 

